/*------------------------------------------------------------------------------*
 * File Name: Selection.h														*
 * Creation: YuI 12/18/2002													    *
 * Purpose: Selection class														*
 * Copyright (c) OriginLab Corp.2001, 2002										*
 * All Rights Reserved															*
 * 																				*
 * Modification Log:															*
 *	RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION								*
 *	Kenny 02/20/2010 QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE				*
 *------------------------------------------------------------------------------*/
#ifndef	_SELECTION_H
#define _SELECTION_H

/** >Internal Origin Objects 
		The Selection class provides methods and properties to access objects in selection

	Example:
		foreach(OriginObject obj in Selection.Objects)
		{
			// .. do something ..
		}
*/
class Selection
{
public:	
	Selection();
	~Selection();
public:
	/**
		Deselect all objects
	Example:
	void ResetSelection()
	{
		Selection.Reset();
	}
	*/
	void	Reset(BOOL bPost=FALSE);
	/** 
		Selects object
	Return:
		FALSE if OriginObject passed to the function is invalid or can not be selected
	Example:
	void AddObjectToSelection(GraphObject& gr)
	{
		if( gr )
			Selection.Add(gr);
	}
	*/
	BOOL	Add(OriginObject& obj);
	
	/**
		Unselects object
	Return:
		FALSE if OriginObject passed to the function is invalid or not selected
	Example:
	void RemoveObjectFromSelection(GraphObject& gr)
	{
		if( gr )
			Selection.Remove(gr);
	}
	*/
	BOOL	Remove(OriginObject& obj);
	
	/**
		Example:
			void run_Objects()
			{
				OriginObject OrgObj;
				OrgObj = Selection.Objects(0);
				
				GraphObject go;
				go = (GraphObject)OrgObj;
				out_str(go.GetName());
			}
	*/
	OriginObject	Objects(int nIndex = 0);
	

	/// RVD 1/23/2009 QA80-13011 PA_MARKER_ACTIVATION
	/**
		Example: dm.oxf
	*/
	BOOL	SelectAnchorSetHandle(OriginObject& objParent, int nAnchorID, int nHandle=0);
	/// end PA_MARKER_ACTIVATION

	/// Kenny 02/20/2010 QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE
	// Comments last updated by Kenny on 02/20/2010
	/**$
		Remarks:
			Test to see whether a specific object is selected.
		Example1:
			BOOL IsSelected_ex1(GraphObject& gr)
			{
				return Selection.IsSelected(gr);
			}
		Parameters:
			obj = [input] Object to be tested.
		Return:
			Return TRUE if obj is selected, or FALSE otherwise.
	*/
	BOOL	IsSelected(OriginObject& obj);
	/// End QA81-15133 OC_RETRIEVE_OBJECT_SELECTION_STATE

	/**
		Collection of all objects in the selection
		Example:
		foreach(OriginObject obj in Selection.Objects)
		{
			// .. do something ..
		}
	*/
	Collection<OriginObject>	Objects;
};

#endif// _SELECTION_H